import json

from rest_framework import serializers
from command.models import Command
import ast

class CommandSerializer(serializers.ModelSerializer):
    products = serializers.SerializerMethodField()
    supplier = serializers.ReadOnlyField(source='supplier.id')
    warehouse = serializers.ReadOnlyField(source='warehouse.id')

    class Meta:
        model = Command
        fields = '__all__'

    def get_products(self, obj):
        array_convert = []
        for item in obj.products:
            if isinstance(item, str):
                try:
                    array_convert.append(ast.literal_eval(item))
                except Exception:
                    array_convert.append(item)
            else:
                array_convert.append(item)
        return array_convert