from django.db import models
import uuid
from django.contrib.auth.models import User

from customer.models import Customer
from settings.models import Settings
from supplier.models import Supplier
import jsonfield

from warehouse.models import Warehouse


# Create your models here.

class Command(models.Model):
    code = models.CharField(default=str(uuid.uuid4())[:6],max_length=12)
    warehouse = models.ForeignKey(Warehouse, on_delete=models.CASCADE)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)
    supplier = models.ForeignKey(Supplier, on_delete=models.CASCADE)
    command_date = models.DateTimeField(auto_now_add=True)
    receive_date = models.DateTimeField(null=True)
    payment_date = models.DateTimeField(null=True)
    status = models.IntegerField(default=0)
    products = jsonfield.JSONField(default=list)
    port_tax = models.DecimalField(default=0,max_digits=12, decimal_places=1)
    weight_sum = models.DecimalField(default=0,max_digits=12, decimal_places=1)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    command_total = models.DecimalField(default=0,max_digits=12, decimal_places=1)

    def __str__(self):
        return  self.code