from django.shortcuts import render
from rest_framework import viewsets
from rest_framework.permissions import IsAuthenticated
from command.command_serializer import CommandSerializer
from command.models import Command
from customer.models import Customer
from settings.models import Settings
from supplier.models import Supplier
from warehouse.models import Warehouse
from django.http import JsonResponse
from django.shortcuts import get_object_or_404
import json
import uuid


# Create your views here.


class CommandViewSet(viewsets.ModelViewSet):
    queryset = Command.objects.all()
    serializer_class = CommandSerializer
    permission_classes = [IsAuthenticated]

    def create(self, request):
        if request.data.get('warehouse') and request.data.get('port_tax') and request.data.get('weight_sum') and request.data.get('status') and request.data.get('supplier')  and request.data.get('receive_date') and request.data.get('payment_date') and request.data.get('products'):
            warehouse = get_object_or_404(Warehouse,id=request.data.get('warehouse'))
            supplier = get_object_or_404(Customer,id=request.data.get('supplier'))
            organisation = get_object_or_404(Settings, user=request.user)
            items_list = []
            total_sum = 0
            code = str(uuid.uuid4())[:6]


            for item in request.data.get('products'):
                if isinstance(item, str):
                    try:
                        item_dict = json.loads(item)
                    except Exception:
                        continue
                elif isinstance(item, dict):
                    item_dict = item
                else:
                    continue
                items_list.append(json.dumps(item_dict))
                total_sum += float(item_dict['selling_price']) * float(item_dict['quantity'])

            command = Command.objects.create(
                warehouse=warehouse,
                supplier=supplier,
                receive_date=request.data.get('receive_date'),
                payment_date=request.data.get('payment_date'),
                products=items_list,
                user=request.user,
                organisation=organisation,
                command_total=total_sum,
                status=request.data.get('status'),
                port_tax=request.data.get('port_tax'),
                weight_sum=request.data.get('weight_sum'),
                code= code

            )
            command.save()
            return JsonResponse({
                "detail": "success",
                "warehouse": warehouse.id,
                "supplier": command.supplier.id,
                "receive_date": command.receive_date,
                "payment_date": command.payment_date,
                "command_date": command.command_date,
                "status": command.status,
                "port_tax": command.port_tax,
                "weight_sum": command.weight_sum,
            })
        else:
            return JsonResponse({
                "warehouse": ["is required"],
                "supplier": ["is required"],
                "receive_date": ["is required"],
                "payment_date": ["is required"],
                "status": ["is required"],
                "products": ["list of json products is required =>[{}]"],
                "port_tax":["is required"],
                "weight_sum": ["is required"]
            })


    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Command.objects.filter(user=user).order_by("-id")

