import datetime
from time import strptime
import jsonfield
from django.contrib.auth.models import User
from django.db import models

from customer.models import Customer


# Create your models here.

class PaymentMethod(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    label = models.CharField(max_length=200)
    description = models.CharField(max_length=200, null=True)

    def __str__(self):
        return self.label


class Invoice(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    customer = models.ForeignKey(Customer, on_delete=models.CASCADE)
    items = jsonfield.JSONField(default=list)
    paid = models.BooleanField(default=False)
    send = models.BooleanField(default=False)
    invoice_total_amount = models.DecimalField(default=0,max_digits=12, decimal_places=1)
    method = models.ForeignKey(PaymentMethod, on_delete=models.CASCADE)
    create_at = models.DateTimeField(auto_now_add=True)
    create_invoice_at = models.DateField(default=datetime.date.today())
    invoice_expire_at = models.DateField(default=datetime.date.today())
    year_of_invoice = models.IntegerField(default=datetime.date.today().year)
    month_of_invoice = models.IntegerField(default=datetime.date.today().month)
    tva_rate = models.DecimalField(default=0,max_digits=12, decimal_places=2)
    subtotal = models.DecimalField(default=0,max_digits=12, decimal_places=2)
    footer_note = models.TextField(blank=True, default="", null=True)
    proforma_state = models.BooleanField(default=False)
    signature = models.TextField(null=True, default="")
    model_invoice = models.IntegerField(default=0, null=True)
    labor = models.DecimalField(default=0,max_digits=12, decimal_places=2)
    label_model = models.TextField(blank=True, default="")
    payment_rules = models.TextField(blank=True, default="", null=True)
    currency = models.CharField(max_length=10, default="usd")

    # Champ pour relier à la facture externe (DGIRDC)
    external_invoice_id = models.CharField(max_length=255, null=True, blank=True, unique=True)

    def __str__(self):
        return self.customer.name

    @property
    def check_if_invoice_expired(self):
        rest_days = self.invoice_expire_at-self.create_invoice_at
        return rest_days.days
