from items.models import Item
from base64 import b64decode
import uuid
import os
from kappi import settings

PATH_UPLOAD_DB = '/media/pdf/'
PATH_UPLOAD = settings.MEDIA_ROOT + "pdf/"

def create_items(user: object, label: object, price: object, description: object) -> object:
    item = Item.objects.create(user=user,label=label,price=price,description=description)
    item.save()

def pdf_to_base64(base64_string):
    os.makedirs(PATH_UPLOAD, exist_ok=True)

    base64 = b64decode(base64_string, validate=True)
    if base64[0:4] != b"%PDF":
        raise ValueError("Missing the PDF file signature")

    file = '{}.{}'.format(uuid.uuid4(), 'pdf')
    file_path = os.path.join(PATH_UPLOAD, file)
    with open(file_path, 'wb') as f:
        f.write(base64)

    return {
        'final': f'{PATH_UPLOAD_DB}{file}',
        'save': 'save'
    }
