from django.contrib.auth.models import User
from django.db import models


# Create your models here.


class Unity(models.Model):
    user = models.ForeignKey(User,on_delete=models.CASCADE)
    label = models.CharField(max_length=20)

    def __str__(self):
        return self.label


class Item(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    label = models.CharField(max_length=200)
    price = models.DecimalField(max_digits=20,decimal_places=1)
    description = models.CharField(max_length=200)
    unit = models.ForeignKey(Unity, on_delete=models.CASCADE, null=True)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return self.label
