"""
URL configuration for kappi project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
import time

import schedule
from django.contrib import admin
from django.urls import path, include
from drf_yasg import openapi
from drf_yasg.views import get_schema_view
from rest_framework import routers, permissions
from rest_framework.documentation import include_docs_urls

from customer.views import CustomerViewSet
from invoice.views import InvoiceViewSet
from items.views import ItemViewSet,UnityViewSet
from kappi import settings
from sale.views import SaleViewSet
from settings.views import SettingsViewSet
from subscription import views
from subscription.views import SubscriptionViewSet
from notice.views import NoticeViewSet
from user.views import AuthTokenCustomize, UserViewSet
from django.contrib.staticfiles.urls import static
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from version_control.views import VersionControlViewSet
from product.views import ProductViewSet
from category.views import CategoryViewSet
from subcategory.views import SubCategoryViewSet
from supplier.views import SupplierViewSet
from realstock.views import RealStockViewSet
from command.views import CommandViewSet
from warehouse.views import WarehouseViewSet
from tags.views import TagsViewSet

schema_view = get_schema_view(
    openapi.Info(
        title="KAPPI API",
        default_version='v1',
        description="Kappi est une application de creation, de suivi et de partage de vos factures",
        contact=openapi.Contact(email="contact@inafrica.tech"),
        license=openapi.License(name="IN AFRICA"),
    ),
    public=True,
    permission_classes=[permissions.AllowAny],
)

router = routers.DefaultRouter()
router.register('item', ItemViewSet)
router.register('customer', CustomerViewSet)
router.register('settings', SettingsViewSet)
router.register('invoice', InvoiceViewSet)
router.register('user', UserViewSet)
router.register('subscription', SubscriptionViewSet)
router.register('notice', NoticeViewSet)
router.register('version_app', VersionControlViewSet)
router.register('unity', UnityViewSet)
router.register('product', ProductViewSet)
router.register('category', CategoryViewSet)
router.register('subcategory', SubCategoryViewSet)
router.register('supplier', SupplierViewSet)
router.register('realstock', RealStockViewSet)
router.register('command', CommandViewSet)
router.register('warehouse', WarehouseViewSet)
router.register('sale', SaleViewSet)
router.register('tags', TagsViewSet)

urlpatterns = [
    path('api/', include(router.urls)),
    path('admin/', admin.site.urls),
    path('get_payment_information/', views.get_payment_information),
    path('api/auth/', AuthTokenCustomize.as_view(), name='api-token-auth'),
    path('docs/', include_docs_urls(title='Todo Api')),
    path(r'^swagger(?P<format>\.json|\.yaml)$', schema_view.without_ui(cache_timeout=0), name='schema-json'),
    path(r'^swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    path('redoc/', schema_view.with_ui('redoc', cache_timeout=0), name='schema-redoc'),
]
urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
