#!/usr/bin/env python
"""Django's command-line utility for administrative tasks."""
import os
import sys

# --- DÉBUT DU PATCH DE COMPATIBILITÉ ---
try:
    import django
    from django.utils import translation
    
    # 1. Patch pour 'ugettext_lazy' (demandé par jsonfield)
    if not hasattr(translation, 'ugettext_lazy'):
        translation.ugettext_lazy = translation.gettext_lazy
        import django.utils.translation
        django.utils.translation.ugettext_lazy = translation.gettext_lazy

    # 2. Patch pour 'baseconv' (demandé par django-q)
    try:
        from django.utils import baseconv
    except ImportError:
        # On crée un module fictif pour tromper l'import de django-q
        from types import ModuleType
        baseconv_mock = ModuleType("baseconv")
        # On ajoute l'objet dont django-q a besoin
        baseconv_mock.base62 = type('obj', (object,), {'encode': lambda x: x, 'decode': lambda x: x})
        sys.modules['django.utils.baseconv'] = baseconv_mock
except ImportError:
    pass
# --- FIN DU PATCH DE COMPATIBILITÉ ---

def main():
    """Run administrative tasks."""
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'kappi.settings')
    try:
        from django.core.management import execute_from_command_line
    except ImportError as exc:
        raise ImportError(
            "Couldn't import Django. Are you sure it's installed and "
            "available on your PYTHONPATH environment variable? Did you "
            "forget to activate a virtual environment?"
        ) from exc
    execute_from_command_line(sys.argv)


if __name__ == '__main__':
    main()