from django.shortcuts import render
from rest_framework import viewsets
from django.http import JsonResponse

from supplier.models import Supplier
from warehouse.models import Warehouse
from .models import Product
from .product_serializer import ProductSerializer
from warehouse.warehouse_serializer import WarehouseSerializer
from rest_framework.permissions import IsAuthenticated
from settings.models import Settings
from subcategory.models import SubCategory
from rest_framework.decorators import action
from django.db.models import Count,Sum
from django.core import serializers
from django.shortcuts import get_object_or_404

# Create your views here.
class ProductViewSet(viewsets.ModelViewSet):
    queryset = Product.objects.all()
    serializer_class = ProductSerializer
    permission_classes =[IsAuthenticated]

    def create(self, request, *args, **kwargs):
        data = request.data
        if data.get('label') and data.get('warehouse') and data.get('selling_price') and data.get('purchase_price') and data.get('subcategory') and data.get('quantity') and data.get('stock') and data.get('supplier') and data.get('unit'):
            product = Product.objects.filter(label=data.get('label'), user=request.user).exists()
            if not product:
                try:
                    settings = Settings.objects.get(user=request.user)
                except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Organisation for the user do not exist"
                    }, status=400)
                
                try:
                    subcategory = SubCategory.objects.get(id=data.get('subcategory'))
                except SubCategory.DoesNotExist:
                    return JsonResponse({
                        "detail": "Subcategory do not exist"
                    }, status=400)
                
                try:
                    supplier = Supplier.objects.get(id=data.get('supplier'))
                except Supplier.DoesNotExist:
                    return JsonResponse({
                        "detail": "Supplier do not exist"
                    }, status=400)

                try:
                    warehouse = Warehouse.objects.get(id=data.get('warehouse'))
                except Warehouse.DoesNotExist:
                    return JsonResponse({
                        "detail": "warehouse do not exist"
                    }, status=400)

                product = Product.objects.create(
                    user=request.user,
                    label=data.get('label'),
                    description=data.get('description'),
                    selling_price=data.get('selling_price'),
                    purchase_price=data.get('purchase_price'),
                    stock=data.get('stock'),
                    tags=data.get('tags'),
                    supplier=supplier,
                    color=data.get('color'),
                    weight=data.get('weight'),
                    unit=data.get('unit'),
                    size=data.get('size'),
                    width=data.get('width'),
                    height=data.get('height'),
                    length=data.get('length'),
                    quantity=data.get('quantity'),
                    subcategory=subcategory,
                    organisation=settings,
                    warehouse=warehouse,
                    category=subcategory.category
                )
                product.save()
            else:
                return JsonResponse({
                    "detail": "product already exists"
                })
            return JsonResponse({
                "detail": "success",
                "id": product.id,
                "label": product.label,
                "description": product.description,
                "selling_price": product.selling_price,
                "purchase_price": product.purchase_price,
                "quantity": product.quantity,
                "unit": product.unit,
                "stock": product.stock,
                "supplier": product.supplier.name,
                "subcategory": product.subcategory.label,
                "category": subcategory.category.id,
                "created_at" : product.created_at,
                "user" : product.user.username,
                "organisation" : product.organisation.name_compagny,
                "warehouse" : warehouse.id
            })
        else:
            return JsonResponse({
                "label": "is required",
                "selling_price": "is required",
                "purchase_price": "is required",
                "subcategory": "is required",
                "quantity": "is required",
                "stock": "is required",
                "unit": "is required",
                "supplier": "is required",
                "warehouse": "is required"
                })

    @action(methods=['GET','POST'], detail=False)
    def get_products_by_warehouse(self, request):
        if request.data.get("warehouse"):
            products = Product.objects.filter(warehouse=request.data.get("warehouse"))
            warehouse = get_object_or_404(Warehouse, id=request.data.get("warehouse"))
            products_stock = Product.objects.filter(warehouse=request.data.get("warehouse")).values(
                "warehouse").annotate(
                stock_products=Sum('stock'))
            serializer_product = ProductSerializer(products, many=True)
            serializer_warehouse = WarehouseSerializer([warehouse], many=True)

            products_list = []
            for product in products_stock:
                products_list.append(product["stock_products"])
            if len(products_list) > 0:
                stock_prod = 0 + products_list[0]
            else:
                stock_prod = 0

            return JsonResponse({
                "product": serializer_product.data,
                "warehouse": serializer_warehouse.data,
                "stock_products": stock_prod
            }, safe=False)
        else:
            return JsonResponse({
                "warehouse": "is required",
            }, safe=False)
