from django.db import models
from product.models import Product
from django.contrib.auth.models import User
from settings.models import Settings

# Create your models here.
class RealStock(models.Model):
    product = models.ForeignKey(Product, on_delete=models.PROTECT)
    quantity = models.IntegerField(default=0)
    operation_types = models.BooleanField(default=True)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)
    created_at = models.DateTimeField(auto_now_add=True)
