from django.shortcuts import render
from rest_framework import viewsets
from django.http import JsonResponse

from product.models import Product
from .realstock_serializer import RealStockSerializer
from .models import RealStock
from rest_framework.permissions import IsAuthenticated
from settings.models import Settings

# Create your views here.
class RealStockViewSet(viewsets.ModelViewSet):
    queryset = RealStock.objects.all()
    serializer_class = RealStockSerializer
    permission_classes =[IsAuthenticated]

    def create(self, request, *args, **kwargs):
        data = request.data
        if data.get('product') and data.get('quantity') and data.get('operation_types'):        
            try:
                product = Product.objects.get(id=data.get('product'))
            except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Product do not exist"
                    }, status=400)
            
            try:
                setting = Settings.objects.get(user=request.user)
            except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Organisation for the user do not exist"
                    }, status=400)
                
            realstock = RealStock.objects.create(
                user=request.user,
                product=product,
                quantity=data.get('quantity'),
                operation_types=data.get('operation_types'),
                organisation=setting
            )
            realstock.save()

            return JsonResponse({
                "detail": "Real Stock created successfully"
            }, status=201)
        else:
            return JsonResponse({
                "detail": "Product, quantity and operation types are required"
            }, status=400)



    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return RealStock.objects.filter(user=user).order_by("-id")
