from django.shortcuts import render, get_object_or_404
from rest_framework import viewsets
from django.http import JsonResponse
from .models import Sale
from .sale_serializer import SaleSerializer
from rest_framework.permissions import IsAuthenticated
from product.models import Product
from settings.models import Settings
from realstock.models import RealStock
import json


# Create your views here.
class SaleViewSet(viewsets.ModelViewSet):
    queryset = Sale.objects.all()
    serializer_class = SaleSerializer
    permission_classes = [IsAuthenticated]

    def create(self, request, *args, **kwargs):
        data = request.data
        items_list = []
        if data.get('products') and data.get('discount') >= 0:

            try:
                organisation = Settings.objects.get(user=request.user)
            except Settings.DoesNotExist:
                return JsonResponse({
                    "detail": "Organisation do not exist"
                }, status=400)

            try:
                for item in data.get('products'):
                    product = get_object_or_404(Product, id=item['id'])
                    product.quantity = product.quantity - int(item['quantity'])
                    product.save()
                    realstock = RealStock.objects.create(
                        product=product,
                        quantity=item['quantity'],
                        user=request.user,
                        organisation=organisation
                    )
                    realstock.save()

                    items_list.append(json.dumps(item))

            except Product.DoesNotExist:
                return JsonResponse({
                    "detail": "Product do not exist"
                }, status=400)

            sale = Sale.objects.create(
                user=request.user,
                product=items_list,
                discount=data.get('discount'),
                organisation=organisation
            )

            sale.save()

            return JsonResponse({
                "id": sale.id,
                "reference": sale.reference,
                "create_at": sale.create_at,
                "user": sale.user.username,
                "organisation": sale.organisation.id
            })
        else:
            return JsonResponse({
                "products": ["list of json products is required =>[{}]"],
                "discount": "is required"
            })

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Sale.objects.filter(user=user).order_by("-id")
