import base64
from PIL import Image
from io import BytesIO
import uuid
from kappi import settings

PATH_UPLOAD = settings.MEDIA_ROOT + "logo/"


def base64_in_image(base64_string):
    try:
        string_data = base64_string
        img_str = string_data.split(';base64,')
        if "format" in img_str:
            format, img_str = string_data.split(';base64,')
            extension = format.split('/')[-1]
        else:
            extension = 'png'

        img = Image.open(BytesIO(base64.b64decode(string_data)))
        file_name = '{}.{}'.format(uuid.uuid4(), extension)
        file_save = f'{PATH_UPLOAD}{file_name}'
        img.save(PATH_UPLOAD + file_name, extension)

        return {'final': file_save, 'save': f'{file_name}'}

    except:
        return {'final': "error", 'save': 'error'}