from django.contrib.auth import logout
from django.core.exceptions import ObjectDoesNotExist
from rest_framework import viewsets, status
from rest_framework.decorators import action
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response

from settings.settings_serializer import SettingsSerializer
from settings.utils import base64_in_image
from django.shortcuts import get_object_or_404
from settings.models import Settings
import phonenumbers
from validate_email import validate_email

# Create your views here.

class SettingsViewSet(viewsets.ModelViewSet):
    queryset = Settings.objects.all()
    serializer_class = SettingsSerializer
    permission_classes = [IsAuthenticated]

    def create(self, request):

        if "name_compagny" in request.data and "address_company" in request.data \
                and "email" in request.data and "country" in request.data and "footer_invoice" in request.data \
                and "business_phone_number" in request.data and "devise" in request.data and "payment_method" in request.data \
                and "register_number_company" in request.data and "signature" in request.data and "code_country" in request.data and "id_national" in request.data and "impot_number" in request.data and "exchange_rate" in request.data:

            user_exist = Settings.objects.filter(user=request.user).exists()
            phone_number = phonenumbers.parse(request.data.get('business_phone_number'), request.data.get('code_country'))
            email_is_valid = validate_email(request.data.get('email'))

            if user_exist is True:
                if phonenumbers.is_valid_number(phone_number) and email_is_valid is True:
                    formatted_phone = phonenumbers.format_number(phone_number, phonenumbers.PhoneNumberFormat.INTERNATIONAL)
                    image_convert = base64_in_image(request.data.get('logo_company'))
                    settings_user = get_object_or_404(Settings, user=request.user)
                    settings_user.address_company = request.data.get('address_company')
                    settings_user.email = request.data.get('email')
                    settings_user.country = request.data.get('country')
                    settings_user.business_phone_number = formatted_phone
                    settings_user.devise = request.data.get('devise')
                    settings_user.payment_method = request.data.get('payment_method')
                    settings_user.name_compagny = request.data.get('name_compagny')
                    settings_user.register_number_company = request.data.get('register_number_company')
                    settings_user.footer_invoice = request.data.get('footer_invoice')
                    settings_user.code_country = request.data.get('code_country')
                    settings_user.signature = request.data.get('signature')
                    settings_user.id_national = request.data.get('id_national')
                    settings_user.impot_number = request.data.get('impot_number')
                    settings_user.exchange_rate = request.data.get('exchange_rate')

                    if image_convert["save"] != "error":
                        settings_user.logo_company = "logo/"+image_convert["save"]

                    settings_user.save()

                    return Response({
                        'detail-en': "the settings are updated",
                        "detail-fr": "les paramètres sont mis à jour"
                    }, status=status.HTTP_200_OK)
                else:
                    return Response({
                        'detail-en': "invalid phone number or email",
                        "detail-fr": "num�ro de téléphone ou email invalide"
                    })

            else:
                invoice = Settings.objects.create(
                    user=request.user,
                    name_compagny=request.data.get('name_compagny'),
                    logo_company=request.data.get('logo_company'),
                    address_company=request.data.get('address_company'),
                    email=request.data.get('email'),
                    country=request.data.get('country'),
                    business_phone_number=request.data.get('business_phone_number'),
                    devise=request.data.get('devise'),
                    footer_invoice=request.data.get('footer_invoice'),
                    payment_method=request.data.get('payment_method'),
                    code_country=request.data.get('code_country'),
                    register_number_company=request.data.get('register_number_company'),
                    id_national=request.data.get('id_national'),
                    impot_number=request.data.get('impot_number'),
                    exchange_rate=request.data.get('exchange_rate')
                )
                invoice.save()

                return Response({
                    'detail-en': f"settings created successfully",
                    "detail-fr": f"paramètres crée avec succès"
                }, status=status.HTTP_200_OK)

        else:

            return Response({
                "name_compagny": 'required',
                "logo_company": 'required',
                "address_company": 'required',
                "email": 'required',
                "country": 'required',
                "business_phone_number": 'required',
                "devise": 'required',
                "footer_invoice": 'required',
                "payment_method": 'required',
                "register_number_company": 'required',
                "code_country":'required',
                "signature": 'required',
                "impot_number": "rerquired",
                "id_national": 'required',
                "exchange_rate": "required"
            }, status=status.HTTP_200_OK)

    @action(detail=False, methods=['POST'])
    def update_logo(self, request):
        user_exist = Settings.objects.filter(user=request.user).exists()
        if user_exist is True and request.data.get('logo_company'):

            try:
                image_convert = base64_in_image(request.data.get('logo_company'))
                settings_user = get_object_or_404(Settings, user=request.user)
                if image_convert["save"] != "error":
                    settings_user.logo_company = "logo/" + image_convert["save"]
                    settings_user.save()

                    print(settings_user.logo_company)

                    return Response({
                        'detail-en': "the logo is updated",
                        "detail-fr": "le logo est mis à jour"
                    }, status=status.HTTP_200_OK)
                else:
                    return Response({
                        'detail-en': "error in the image",
                        "detail-fr": "erreur dans l'image"
                    }, status=status.HTTP_200_OK)
            except:
                return Response({
                    'detail-en': "error in the image",
                    "detail-fr": "erreur dans l'image"
                }, status=status.HTTP_200_OK)

        else:
            return Response({
                'detail-en': "settings user does not exist or the logo_company is not provided",
                "detail-fr": "paramètres d'utilisateur inexistant ou le logo_company n'est pas fourni"
            }, status=status.HTTP_200_OK)



    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Settings.objects.filter(user=user)

    @action(detail=False, methods=['GET'])
    def logout(self, request):
        try:
            request.user.auth_token.delete()
            logout(request)
            return Response({"success": "Successfully logged out."}, status=status.HTTP_200_OK)

        except (AttributeError, ObjectDoesNotExist):
            return Response({"error": "You are not logged out."}, status=status.HTTP_200_OK)

    @action(detail=False, methods=['POST'])
    def update_dgi_token(self, request):
        """
        Met à jour le jeton d'API DGI dans les paramètres de l'utilisateur courant.
        Body attendu: { "dgi_api_token": "<token>" }
        """
        token = request.data.get('dgi_api_token')
        if not token:
            return Response({
                'detail-en': "dgi_api_token is required",
                'detail-fr': "dgi_api_token est requis"
            }, status=status.HTTP_400_BAD_REQUEST)

        settings_user = Settings.objects.filter(user=request.user).first()
        if not settings_user:
            settings_user = Settings.objects.create(user=request.user)

        settings_user.dgi_api_token = token
        settings_user.save()

        return Response({
            'detail-en': "DGI API token updated",
            'detail-fr': "Jeton API DGI mis à jour"
        }, status=status.HTTP_200_OK)


