from django.db import models
from category.models import Category
from django.contrib.auth.models import User
from settings.models import Settings

# Create your models here.
class SubCategory(models.Model):
    label = models.CharField(max_length=200)
    category = models.ForeignKey(Category, on_delete=models.CASCADE)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    organisation = models.ForeignKey(Settings, on_delete=models.CASCADE)

    def __str__(self):
        return self.label