from datetime import datetime, timedelta, date

from django.contrib.auth.models import User
from django.db import models


# Create your models here.

class Subscription(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    started_date = models.DateTimeField(auto_now_add=True)
    subscription_api_id = models.TextField(null=True)
    method = models.TextField(default="", null=True)
    number_phone = models.TextField(null=True)
    subscription_state = models.BooleanField(default=False)
    delay = models.IntegerField(default=30)

    @property
    def check_subscription(self):
        to_day = datetime.strptime(date.today().strftime("%m/%d/%y"), "%m/%d/%y")
        string_date = self.started_date.strftime("%m/%d/%y")
        date_start = datetime.strptime(string_date, "%m/%d/%y")
        end_date = date_start + timedelta(days=self.delay * int(1))
        days_available = end_date - to_day
        days = days_available.days
        return days
    def __str__(self):
        return self.user.username
