import uuid
import requests
from django.contrib.auth.models import User
from django.http import JsonResponse
from rest_framework import viewsets, status
from rest_framework.decorators import action
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response
from rest_framework.authtoken.models import Token
from subscription.models import Subscription
from subscription.subscription_serializer import SubscriptionSerializer


class SubscriptionViewSet(viewsets.ModelViewSet):
    queryset = Subscription.objects.all()
    serializer_class = SubscriptionSerializer
    permission_classes = [IsAuthenticated]

    def create(self, request):

        reference = str(uuid.uuid4())[:6]
        user_id = str(request.user.id)
        url = 'https://api.maxicashapp.com/payentry?data={PayType:"MaxiCash",Amount:"1200",Currency:"maxiDollar",MerchantID:"01b1482d0e55416cacf36befccfa607f",MerchantPassword:"2cbed6e12a4c439dab59f49845465407",Language:"fr",Reference:"' + reference + '",Accepturl:"https://assainissement.space/get_payment_information/?iduser=' + user_id + '",Declineurl:"http://assainissement.space/get_payment_information/",NotifyURL:""}'
        return Response({
            "detail": url.replace("\"", "'")
        })


    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Subscription.objects.filter(user=user)


    @action(detail=False, methods=['get'])
    def verify_valid_subscription_user_webhook(self, request):
        counting_valid_suscriptions = 0
        user = User.objects.get(id=request.user.id)
        subscription = Subscription.objects.filter(user=user)
        for subscription in subscription:
            if subscription.check_subscription > 0:
                counting_valid_suscriptions += 1
            else:
                counting_valid_suscriptions += 0

        if counting_valid_suscriptions > 0:
            return JsonResponse({
                "success": True,
                "subscription": True
            })
        else:
            return JsonResponse({
                "success": True,
                "subscription": False
            })


def get_payment_information(request):
    if request.GET['reference'] and request.GET['Method'] and request.GET['iduser']:

        if request.GET['status'] == 'failed':
            return JsonResponse({
                "detail-en": "operation cancelled, please start again",
                "detail-fr": "opération annulée, veillez recommencer."})
        else:
            user = User.objects.get(id=request.GET['iduser'])
            subscription = Subscription.objects.create(
                user=user,
                subscription_api_id=request.GET['reference'],
                method=request.GET['Method'],
                subscription_state=True
            )
            subscription.save()

            token = Token.objects.get(user=user)
            return JsonResponse({
                "detail": "success",
                'token': token.key,
                'id': user.id,
                'username': user.username,
                'password': user.password,
                'first_name': user.first_name,
                'last_name': user.last_name,
                'email': user.email,
                'subscription': True
            })
    else:
        return JsonResponse({
            "detail-en": "verify your parameters (Method,reference) ",
            "detail-fr": "Operation Impossible, veuillez contacter votre operateur "})

