from django.shortcuts import render
from rest_framework import viewsets
from rest_framework import permissions

from settings.models import Settings
from .models import Supplier
from .supplier_serializer import SupplierSerializer
from django.http import JsonResponse

# Create your views here.
class SupplierViewSet(viewsets.ModelViewSet):
    queryset = Supplier.objects.all()
    serializer_class = SupplierSerializer
    permission_classes = [permissions.IsAuthenticated]

    def create(self, request):
        data = request.data

        if data.get('name') and data.get('phone'):
            supplier = Supplier.objects.filter(name=data.get('name'), user=request.user).exists()
            if not supplier:
                try:
                    setting = Settings.objects.get(user=request.user)
                except Settings.DoesNotExist:
                    return JsonResponse({
                        "detail": "Organisation for the user do not exist"
                    }, status=400)
                
                supplier = Supplier.objects.create(
                    user=request.user,
                    name=data.get('name'),
                    phone=data.get('phone'),
                    email=data.get('email'),
                    address=data.get('address'),
                    organisation=setting
                )
                supplier.save()
            else:
                return JsonResponse({
                    "detail": "supplier already exists"
                })
            return JsonResponse({
                "detail": "success",
                "id": supplier.id,
                "name": supplier.name,
                "phone": supplier.phone,
                "email": supplier.email,
                "address": supplier.address,
                "user": supplier.user.username,
                "organisation" : supplier.organisation.name_compagny
            })
        else:
            return JsonResponse({
                "name": "is required",
                "phone": "is required"
            })


    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Supplier.objects.filter(user=user).order_by("-id")