from rest_framework import viewsets
from rest_framework.permissions import IsAuthenticated
from .models import Tags
from .tags_serializer import TagsSerializer
from rest_framework.decorators import action
from django.shortcuts import get_object_or_404
from django.http import JsonResponse
from settings.models import Settings


# Create your views here.
class TagsViewSet(viewsets.ModelViewSet):
    queryset = Tags.objects.all()
    serializer_class = TagsSerializer
    permission_classes = [IsAuthenticated]

    def get_queryset(self):
        """
        This view should return a list of all the purchases
        for the currently authenticated user.
        """
        user = self.request.user
        return Tags.objects.filter(user=user).order_by("-id")

    @action(methods=["POST"], detail=False)
    def save_multiple_tags(self, request):
        if isinstance(request.data.get('tags'), list) and len(request.data.get('tags')) > 0:
            try:
                organisation = get_object_or_404(Settings, user=request.user)
                tag_list_exist = []
                tag_list_saved = []
                for tag in request.data.get('tags'):
                    if_tag_exist = Tags.objects.filter(user=request.user,label=tag['label']).exists()
                    if if_tag_exist == True and tag['color']:
                        tag_list_exist.append(tag['label'])
                    else:
                        tags = Tags.objects.create(
                            label=tag['label'],
                            color=tag['color'],
                            user=request.user,
                            organisation=organisation
                        )
                        tags.save()
                        tag_list_saved.append(tag['label'])

                return JsonResponse({
                    'exist': tag_list_exist,
                    'saved': tag_list_saved
                })
            except:
                return JsonResponse({'details': 'tags no saved'})
        else:
            return JsonResponse({'tags': 'list of tags is required'})